<?php
	$post_image = '';
	$attachment_id = get_post_thumbnail_id($post->ID);
	if ($attachment_id) {
		$post_image = thegem_generate_thumbnail_src($attachment_id, 'thegem-blog-timeline-large');
		if ($post_image && $post_image[0]) {
			$post_image = $post_image[0];
		}
	}
	
	$isProduct = get_post_type($post->ID) == 'product';
	if ($isProduct) {
		global $thegem_product_data;
		
		$params = [
			'isLegacy' => $thegem_product_data['product_page_layout'] === 'legacy',
			'isShare' => $thegem_product_data['product_page_elements_share'],
			'shareTitle' => $thegem_product_data['product_page_elements_share_title'],
			'isFacebook' => $thegem_product_data['product_page_elements_share_facebook'],
			'isTwitter' => $thegem_product_data['product_page_elements_share_twitter'],
			'isPinterest' => $thegem_product_data['product_page_elements_share_pinterest'],
			'isTumblr' => $thegem_product_data['product_page_elements_share_tumblr'],
			'isLinkedin' => $thegem_product_data['product_page_elements_share_linkedin'],
			'isReddit' => $thegem_product_data['product_page_elements_share_reddit'],
		];
	}
?>

<?php if ($isProduct && !$params['isLegacy']): ?>
	<div class="socials-sharing socials socials-colored-hover">
		
		<?php if ($params['isLinkedin']): ?>
			<a class="socials-item" target="_blank" href="<?php echo esc_url('https://www.linkedin.com/shareArticle?mini=true&url='.urlencode(get_permalink()).'&amp;title='.urlencode(get_the_title())); ?>&amp;summary=<?php echo urlencode(get_the_excerpt()); ?>" title="LinkedIn"><i class="socials-item-icon linkedin"></i></a>
		<?php endif; ?>
	
	</div>
<?php else: ?>
	<div class="socials-sharing socials socials-colored-hover">
		<a class="socials-item" target="_blank" href="<?php echo esc_url('https://www.linkedin.com/shareArticle?mini=true&url='.urlencode(get_permalink()).'&amp;title='.urlencode(get_the_title())); ?>&amp;summary=<?php echo urlencode(get_the_excerpt()); ?>" title="LinkedIn"><i class="socials-item-icon linkedin"></i></a>
	</div>
<?php endif; ?>

